#!/kronos/ash

lgl_xkeyboard()
{
	xlayout="`echo "$1"|cut -f1 -d ':'`"
	xvariant="`echo "$1"|cut -f2 -d ':'`"

	if [ -d "/etc/X11/xorg.conf.d/" ] && [ "x$xlayout" != "x" ]
	then
		printf "Section \"InputClass\"\n" > /etc/X11/xorg.conf.d/00-keyboard.conf
		printf "        Identifier \"system-keyboard\"\n" >> /etc/X11/xorg.conf.d/00-keyboard.conf
		printf "        \n" >> /etc/X11/xorg.conf.d/00-keyboard.conf
		printf "        MatchIsKeyboard \"on\"\n" >> /etc/X11/xorg.conf.d/00-keyboard.conf
		printf "        Option \"XkbLayout\" \"%s\"\n" "$xlayout" >> /etc/X11/xorg.conf.d/00-keyboard.conf
		printf "        Option \"XkbModel\" \"pc104\"\n" >> /etc/X11/xorg.conf.d/00-keyboard.conf
		if [ "x$xvariant" != "x" ]
		then
			printf "        \"XkbVariant\" \",%s\"\n" "$xvariant" >> /etc/X11/xorg.conf.d/00-keyboard.conf
		fi
		printf "EndSection\n" >> /etc/X11/xorg.conf.d/00-keyboard.conf
	fi
	return
}

lgl_network()
{
	gaiaconf="$1"
	hostname="`echo "$gaiaconf" |lpm-ldifget -f -a lglHostname`"
	domain="`echo "$gaiaconf" |lpm-ldifget -f -a lglDomain`"
	iface="`echo "$gaiaconf" |lpm-ldifget -f -a lglNetInterface`"
	if [ "$iface" != "user" ]
	then
		method="`echo "$gaiaconf" |lpm-ldifget -f -a lglNetMethod`"
		address="`echo "$gaiaconf" |lpm-ldifget -f -a lglNetAddr`"
		prefix="`echo "$gaiaconf" |lpm-ldifget -f -a lglNetPrefix`"
		gateway="`echo "$gaiaconf" |lpm-ldifget -f -a lglNetGateway`"
		dnssearch="`echo "$gaiaconf" |lpm-ldifget -f -a lglNetDnsSearch`"
		dnsserver="`echo "$gaiaconf" |lpm-ldifget -f -a lglNetDnsServer`"
	fi
	# First, we let udev handle the fixed device
	/bin/bash /lib/udev/init-net-rules.sh
	# We also set the hostname in any case
	echo "$hostname" > /etc/hostname
	# We also set the localhost stuff in any case
	echo "127.0.0.1 localhost" > /etc/hosts
	# If we have no interface now, we're finished
	if [ "x$iface" = "x" ] || [ "$iface" = "user" ]
	then
		return
	fi
	if [ "$method" = "dhcp" ]
	then
		printf "ONBOOT=\"yes\"\n" > /etc/sysconfig/ifconfig.$iface
		printf "IFACE=\"%s\"\n" "$iface" >> /etc/sysconfig/ifconfig.$iface
		printf "SERVICE=\"dhcpcd\"\n" >> /etc/sysconfig/ifconfig.$iface
		printf "DHCP_START=\"-b -q \"\n" >> /etc/sysconfig/ifconfig.$iface
		printf "DHCP_STOP=\"-k  \"\n" >> /etc/sysconfig/ifconfig.$iface
	elif [ "$method" = "static" ]
	then
		printf "ONBOOT=\"yes\"\n" > /etc/sysconfig/ifconfig.$iface
		printf "IFACE=\"%s\"\n" "$iface" >> /etc/sysconfig/ifconfig.$iface
		printf "SERVICE=\"ipv4-static\"\n" >> /etc/sysconfig/ifconfig.$iface
		printf "IP=\"%s\"\n" "$address" >> /etc/sysconfig/ifconfig.$iface
		printf "GATEWAY=\"%s\"\n" "$gateway" >> /etc/sysconfig/ifconfig.$iface
		printf "PREFIX=\"%s\"\n" "$prefix" >> /etc/sysconfig/ifconfig.$iface
		printf "domain %s\n" "$dnssearch" >/etc/resolv.conf
		printf "nameserver %s\n" "$dnsserver" >>/etc/resolv.conf
		printf "%s %s.%s %s\n" "$address" "$hostname" "$domain" "$hostname" >> /etc/hosts
	fi
	return

}

lgl_grub_conf()
{
	pdev="$1"
	loccon="$2"
	locser="$3"
	# The first step is to simply replace any sda1 in linux.conf with pdev
	sed -i "s,/dev/sda1,$pdev,g" /etc/lgrub-config.d/linux.conf
	# The next step is to translate the linux /dev to grub
	# hd0,1
	# We currently only support /dev/sdxn stuff
	devtab="
/dev/sda1:hd0,1
/dev/sda2:hd0,2
/dev/sda3:hd0,3
/dev/sda4:hd0,4
/dev/sda5:hd0,5
/dev/sda6:hd0,6
/dev/sda7:hd0,7
/dev/sda8:hd0,8
/dev/sda9:hd0,9
/dev/sdb1:hd1,1
/dev/sdb2:hd1,2
/dev/sdb3:hd1,3
/dev/sdb4:hd1,4
/dev/sdb5:hd1,5
/dev/sdb6:hd1,6
/dev/sdb7:hd1,7
/dev/sdb8:hd1,8
/dev/sdb9:hd1,9
/dev/sdc1:hd2,1
/dev/sdc2:hd2,2
/dev/sdc3:hd2,3
/dev/sdc4:hd2,4
/dev/sdc5:hd2,5
/dev/sdc6:hd2,6
/dev/sdc7:hd2,7
/dev/sdc8:hd2,8
/dev/sdc9:hd2,9
/dev/sdd1:hd3,1
/dev/sdc2:hd3,2
/dev/sdd3:hd3,3
/dev/sdd4:hd3,4
/dev/sdd5:hd3,5
/dev/sdd6:hd3,6
/dev/sdd7:hd3,7
/dev/sdd8:hd3,8
/dev/sdd9:hd3,9
"
	gdsk="` echo "$devtab"|grep "^$pdev"|cut -f2 -d ':'`"
	sed -i "s/hd0,1/$gdsk/g" /etc/lgrub-config.d/linux.conf
	if [ "$loccon" = "ser" ]
	then
		serunit="`echo "$locser" |cut -f1 -d ':'`"
		serspeed="`echo "$locser" |cut -f2 -d ':'`"
		serstop="`echo "$locser" |cut -f3 -d ':'`"
		echo "serial --unit=$serunit --speed=$serspeed --stop=$serstop" >> /etc/lgrub-config.d/header.conf
		echo "terminal_input serial" >> /etc/lgrub-config.d/header.conf
		echo "terminal_output serial" >> /etc/lgrub-config.d/header.conf
		sed -i "s/ ro:/ ro console=ttyS0,$serspeed/g" /etc/lgrub-config.d/linux.conf
	fi
	lgrub-config > /boot/grub/grub.cfg
}
 

lgl_user()
{
	user="$1"
	name="$2"
	hash="$3"
	# The initial user gets a good set of admin rights
    admgroups="sudo,adm,wheel,audio,video"
	/usr/sbin/useradd -m -s /bin/bash -G $admgroups -c "$name" -p "$hash" $user
}

lgl_profile()
{
	charset="$1"
	language="$2"
	echo "export LANG=$language.$charset"
	echo ""
}

lgl_clock()
{
	clock="$1"
	echo "# Set UTC=1 if your system clock stores time in UTC"
	if [ "x$clock" = "localtime" ]
	then
		echo "UTC=0"
	else
		echo "UTC=1"
	fi
	echo "# Set this to any options you might need to give to hwclock,"
	echo "# such as machine hardware clock type for Alphas."
	echo "CLOCKPARAMS="
}

lgl_console()
{
	charset="$1"
	keymap="$2"
	font="$3"
	# We support only utf-8 charset, or latin1-9
	if [ "x$charset" = "xUTF-8" ]
	then
		echo 'UNICODE="1"'
	fi
	fontadd=""
	if [ "x$keymap" != "x" ]
	then
		echo "KEYMAP=\"$keymap\""
		if echo "$keymap" |grep latin1 >/dev/null
		then
			echo 'LEGACY_CHARSET="iso-8859-1"'
			fontadd=" -m 8859-1"
		elif echo "$keymap" |grep latin5 >/dev/null
		then
			echo 'LEGACY_CHARSET="iso-8859-5"'
			fontadd=" -m 8859-5"
		elif echo "$keymap" |grep latin8 >/dev/null
		then
			echo 'LEGACY_CHARSET="iso-8859-9"'
			fontadd=" -m 8859-9"
		fi
	fi
	if [ "x$font" != "x" ]
	then
		echo "FONT=\"$font $fontadd\""
	fi
}

PATH=/sbin:/bin:/usr/sbin:/usr/bin:/kronos export PATH
/kronos/lpm -l /tmp/zeusrise.log -f -I glibc lpm openssl-bin 
/usr/bin/lpm -l /tmp/zeusrise.log -f -I util-linux shadow grub lgrub-conf procps man-db vim-core
/kronos/lpm -l /tmp/zeusrise.log -f -I lgl-bootscripts
PATH=/sbin:/bin:/usr/sbin:/usr/bin export PATH
cp /kronos/lpm-ldifget /bin/
gaiaconf="`cat /kronos/gaia.conf`"

clock="`echo "$gaiaconf" |lpm-ldifget -f -a lglClock`"
timezone="`echo "$gaiaconf" |lpm-ldifget -f -a lglTimezone`"
charset="`echo "$gaiaconf" |lpm-ldifget -f -a lglCharset`"
language="`echo "$gaiaconf" |lpm-ldifget -f -a lglLanguage`"
keymap="`echo "$gaiaconf" |lpm-ldifget -f -a lglKeymap`"
xkbmap="`echo "$gaiaconf" |lpm-ldifget -f -a lglKeymapX11`"

consfont="`echo "$gaiaconf" |lpm-ldifget -f -a lglConsoleFont`"
user="`echo "$gaiaconf" |lpm-ldifget -f -a lglUid`"
name="`echo "$gaiaconf" |lpm-ldifget -f -a lglUser`"
hash="`echo "$gaiaconf" |lpm-ldifget -f -a lglPwdHash`"
roothash="`echo "$gaiaconf" |lpm-ldifget -f -a lglRootPwdHash </dev/null`"
lgldev="`echo "$gaiaconf" |lpm-ldifget -f -a lglDevice`"
lglcon="`echo "$gaiaconf" |lpm-ldifget -f -a lglConsole`"
lgltype="`echo "$gaiaconf" |lpm-ldifget -f -a lglInstallType`"
lglkernel="`echo "$gaiaconf" |lpm-ldifget -f -a lglKernel`"
lglxkbd="`echo "$gaiaconf" |lpm-ldifget -f -a lglKeymapX11 2>/dev/null`"

/usr/bin/lpm -l /tmp/zeusrise.log -f -I mkinitrd openssh-client

if [ "$lglkernel" = "generic" ]
then
	/usr/bin/lpm -l /tmp/zeusrise.log -f -I kernel-img
elif [ "$lglkernel" = "zfs" ]
then
	/usr/bin/lpm -l /tmp/zeusrise.log -f -I kernel-zfs-img
fi

if [ "$lglcon" = "ser" ]
then
	lglser="`echo "$gaiaconf" |lpm-ldifget -f -a lglSerialParams`"
else
	lglsev=""
fi
echo "clock    : <$clock>"
echo "timezone : <$timezone>"
echo "charset  : <$charset>"
echo "language : <$language>"
echo "keymap   : <$keymap>"
echo "consfont : <$consfont>"
echo "name     : <$name>"
echo "user     : <$user>"
echo "password : <$hash>"

lgl_console "$charset" "$keymap" "$consfont" > /etc/sysconfig/console
lgl_clock "$clock" > /etc/sysconfig/clock
localedef --no-archive -i "$language" -f "$charset" "$language"."$charset"
lgl_profile "$charset" "$language" >> /etc/profile
if [ ! -d /etc/profile.d ]
then
	mkdir -p /etc/profile.d || echo "/etc/profile.d exists, ok"
fi
chmod +x /etc/profile
lgl_user "$user" "$name" "$hash"
if [ "x$roothash" != "x" ]
then
	usermod -p "$roothash" root
fi
if [ -f "/usr/share/zoneinfo/$timezone" ]
then
	cp -v "/usr/share/zoneinfo/$timezone" /etc/localtime
fi
cat > /etc/fstab << "EOF"
# Begin /etc/fstab
# file system       mount-point     type       options               dump  fsck
EOF

have_root_part=N
have_swap_part=N
num_part="`echo "$gaiaconf" |lpm-ldifget -f -c -a lglPart`"
cur_part=1
echo "Number of Partitions: $num_part"
if [ "$num_parts" = "0" ]
then
	echo "No partitions to use defined!!" >&2
else
	while ( [ "$cur_part" -le "$num_part" ] )
	do
		part="`echo "$gaiaconf" |lpm-ldifget -f -n $cur_part -a lglPart`"
		pmnt="`echo "$part"|cut -f1 -d ':'`"
		ptyp="`echo "$part"|cut -f2 -d ':'`"
		pdev="`echo "$part"|cut -f3 -d ':'`"
		lgldev="`echo "$gaiaconf" |lpm-ldifget -f -n $cur_part -a lglPart`"
		if [ "$pmnt" = "/" ]
		then
			have_root_part=Y
			printf "%-16s    %-12s    %-10s %-21s 1     1\n" "$pdev" "$pmnt" "$ptyp" "defaults" >>/etc/fstab
			lgl_grub_conf "$pdev" "$lglcon" "$lglser"
		elif [ "$pmnt" = "swap" ]
		then
			have_swap_part=N
			printf "%-19s %-15s %-10s %-21s 0     0\n" "$pdev" "swap" "swap" "pri=1" >>/etc/fstab
		else
			printf "%-19s %-15s %-10s %-21s 1     1\n" "$pdev" "$pmnt" "$ptyp" "defaults" >>/etc/fstab
		fi
		cur_part="` expr $cur_part + 1 `"
	done
fi
cat >>/etc/fstab << "EOF"
                                                                                
proc                /proc           proc       nosuid,noexec,nodev   0     0
sysfs               /sys            sysfs      nosuid,noexec,nodev   0     0
devpts              /dev/pts        devpts     gid=5,mode=620        0     0
tmpfs               /run            tmpfs      defaults              0     0
devtmpfs            /dev            devtmpfs   mode=0755,nosuid      0     0
EOF

lgl_network "$gaiaconf"
clear
rm /bin/sh
cd /bin
ln -s bash sh
printf "Do you want to install grub in /dev/sda [Y/n] ? "
read ans
printf "\n"
if [ "x$ans" != "xn" ]
then
	echo "Ok, installing grub"
	grub-install /dev/sda
fi
cp -a /kronos /tartarus/
lpm -l /tmp/zeusrise.log -f -D kronos
rm -rf /kronos

>/etc/lpm.conf
printf "dist_name		= LGL\n" >> /etc/lpm.conf
printf "dist_vers		= 1.0\n" >> /etc/lpm.conf
printf "lpm_vers		= 1.0\n" >> /etc/lpm.conf
printf "arch_name		= %s\n" "`uname -m`" >> /etc/lpm.conf
printf "lpc_backend		= lpc-dirs.so\n" >> /etc/lpm.conf

lpm -l /tmp/zeusrise.log -f -I openssh-server net-tools lpc-http ntp iptables bind-client
lpm -l /tmp/zeusrise.log -f -I vixie-cron at rsyslog
lpm -l /tmp/zeusrise.log -f -I logrotate

/etc/init.d/atd stop
/etc/init.d/ntpd stop
/etc/init.d/sshd stop
/etc/init.d/cron stop

if [ "$lgltype" = "desktop" ]
then
	lpm -l /tmp/zeusrise.log -f -I lgl-desktop
	cp /etc/inittab /etc/inittab.old
	sed -e 's/3:initdefault/5:initdefault/g' < /etc/inittab.old > /etc/inittab
	lgl_xkeyboard "$lglxkbd"
	
fi

repo_base="http://lpk.laconian-linux.org/lgl-1.0"
conf_base="lgl10-lpk-laconian-linux-org.conf"
for repo in default updates
do
	echo "site_base=$repo_base/$repo/" > /etc/lpc-http-sites/$repo-$conf_base
	echo "auth_type=none" >> /etc/lpc-http-sites/$repo-$conf_base
done	
sed -i 's/lpc-dirs.so/lpc-http.so/g' /etc/lpm.conf	
if [ "$lglcon" = "ser" ]
then
	serunit="`echo "$lglser" |cut -f1 -d ':'`"
	serspeed="`echo "$lglser" |cut -f2 -d ':'`"
	serstop="`echo "$lglser" |cut -f3 -d ':'`"
	echo "s0:2345:respawn:/sbin/agetty -L ttyS0 $serspeed vt100"  >> /etc/inittab
	echo "s1:2345:respawn:/sbin/agetty -L ttyS1 $serspeed vt100" >> /etc/inittab
fi
cp /tmp/zeusrise.log /var/log
# The stagearea now contains all installed packages. Not really necessary
rm -rf /var/lib/lpm/stagearea/*
rm -f /bin/lpm-ldifget

printf "Ok, installation finished. Restart the system [Y/n] ? "
read ans
printf "\n"
if [ "x$ans" != "xn" ]
then
	echo "Ok, see you in a minute"
	exit
else
	echo "Ok, dropping you to a shell. When you exit, the machine will reboot"
	exec /bin/bash 
fi
