#!/bin/bash
LGL=/mnt/lgl
mkdir -pv $LGL/{dev,proc,sys,run,tmp}
mkdir -p $LGL/var/log
mkdir -p $LGL/bin
mknod -m 600 $LGL/dev/console c 5 1
mknod -m 666 $LGL/dev/null c 1 3
mount -v --bind /dev $LGL/dev
mount -vt devpts devpts $LGL/dev/pts -o gid=5,mode=620
mount -vt proc proc $LGL/proc
mount -vt sysfs sysfs $LGL/sys
mount -vt tmpfs tmpfs $LGL/run
mkdir -p $LGL/tmp
chmod 1777 $LGL/tmp
if [ -h $LGL/dev/shm ]; then
  mkdir -pv $LGL/$(readlink $LGL/dev/shm)
fi
mkdir $LGL/etc
touch $LGL/etc/.first_run
echo "127.0.0.1		localhost" >/etc/hosts
cat > $LGL/etc/nsswitch.conf << "EOF"
# Begin /etc/nsswitch.conf

passwd: files
group: files
shadow: files

hosts: files dns
networks: files

protocols: files
services: files
ethers: files
rpc: files

# End /etc/nsswitch.conf
EOF

cat > $LGL/etc/passwd << "EOF"
root:x:0:0:root:/root:/bin/sh
bin:x:1:1:bin:/dev/null:/bin/false
daemon:x:6:6:Daemon User:/dev/null:/bin/false
nobody:x:99:99:Unprivileged User:/dev/null:/bin/false
EOF
cat > $LGL/etc/group << "EOF"
root:x:0:
bin:x:1:daemon
sys:x:2:
kmem:x:3:
tape:x:4:
tty:x:5:
daemon:x:6:
floppy:x:7:
disk:x:8:
lp:x:9:
dialout:x:10:
audio:x:11:
video:x:12:
utmp:x:13:
usb:x:14:
cdrom:x:15:
adm:x:16:
input:x:24:
sudo:x:27:
mail:x:34:
wheel:x:500:
nogroup:x:99:
users:x:999:
EOF
clear
chroot "$LGL" /kronos/busybox env -i \
    HOME=/                  \
    TERM="$TERM"            \
    lglcon="$lglcon"            \
    lgldev="$lgldev"            \
    TERM="$TERM"            \
    PS1='\u:\w\$ '          \
    PATH=/kronos \
    /kronos/busybox ash -l -c /kronos/kronosrule.sh 

