#!/kronos/ash

lgl_xkeyboard()
{
	xlayout="`echo "$1"|cut -f1 -d ':'`"
	xvariant="`echo "$1"|cut -f2 -d ':'`"

	if [ -d "/etc/X11/xorg.conf.d/" ] && [ "x$xlayout" != "x" ]
	then
		printf "Section \"InputClass\"\n" > /etc/X11/xorg.conf.d/00-keyboard.conf
		printf "        Identifier \"system-keyboard\"\n" >> /etc/X11/xorg.conf.d/00-keyboard.conf
		printf "        \n" >> /etc/X11/xorg.conf.d/00-keyboard.conf
		printf "        MatchIsKeyboard \"on\"\n" >> /etc/X11/xorg.conf.d/00-keyboard.conf
		printf "        Option \"XkbLayout\" \"%s\"\n" "$xlayout" >> /etc/X11/xorg.conf.d/00-keyboard.conf
		printf "        Option \"XkbModel\" \"pc104\"\n" >> /etc/X11/xorg.conf.d/00-keyboard.conf
		if [ "x$xvariant" != "x" ]
		then
			printf "        \"XkbVariant\" \",%s\"\n" "$xvariant" >> /etc/X11/xorg.conf.d/00-keyboard.conf
		fi
		printf "EndSection\n" >> /etc/X11/xorg.conf.d/00-keyboard.conf
	fi
	return
}

lgl_network()
{
	gaiaconf="$1"
	hostname="`echo "$gaiaconf" |ldifget -f -a lglHostname`"
	domain="`echo "$gaiaconf" |ldifget -f -a lglDomain`"
	iface="`echo "$gaiaconf" |ldifget -f -a lglNetInterface`"
	if [ "$iface" != "user" ]
	then
		method="`echo "$gaiaconf" |ldifget -f -a lglNetMethod`"
		address="`echo "$gaiaconf" |ldifget -f -a lglNetAddr`"
		prefix="`echo "$gaiaconf" |ldifget -f -a lglNetPrefix`"
		gateway="`echo "$gaiaconf" |ldifget -f -a lglNetGateway`"
		dnssearch="`echo "$gaiaconf" |ldifget -f -a lglNetDnsSearch`"
		dnsserver="`echo "$gaiaconf" |ldifget -f -a lglNetDnsServer`"
	fi
	# First, we let udev handle the fixed device
	/bin/bash /lib/udev/init-net-rules.sh
	# We also set the hostname in any case
	echo "$hostname" > /etc/hostname
	# We also set the localhost stuff in any case
	echo "127.0.0.1 localhost" > /etc/hosts
	# If we have no interface now, we're finished
	if [ "x$iface" = "x" ] || [ "$iface" = "user" ]
	then
		return
	fi
	if [ "$method" = "dhcp" ]
	then
		printf "ONBOOT=\"yes\"\n" > /etc/sysconfig/ifconfig.$iface
		printf "IFACE=\"%s\"\n" "$iface" >> /etc/sysconfig/ifconfig.$iface
		printf "SERVICE=\"dhcpcd\"\n" >> /etc/sysconfig/ifconfig.$iface
		printf "DHCP_START=\"-b -q \"\n" >> /etc/sysconfig/ifconfig.$iface
		printf "DHCP_STOP=\"-k  \"\n" >> /etc/sysconfig/ifconfig.$iface
	elif [ "$method" = "static" ]
	then
		printf "ONBOOT=\"yes\"\n" > /etc/sysconfig/ifconfig.$iface
		printf "IFACE=\"%s\"\n" "$iface" >> /etc/sysconfig/ifconfig.$iface
		printf "SERVICE=\"ipv4-static\"\n" >> /etc/sysconfig/ifconfig.$iface
		printf "IP=\"%s\"\n" "$address" >> /etc/sysconfig/ifconfig.$iface
		printf "GATEWAY=\"%s\"\n" "$gateway" >> /etc/sysconfig/ifconfig.$iface
		printf "PREFIX=\"%s\"\n" "$prefix" >> /etc/sysconfig/ifconfig.$iface
		printf "domain %s\n" "$dnssearch" >/etc/resolv.conf
		printf "nameserver %s\n" "$dnsserver" >>/etc/resolv.conf
		printf "%s %s.%s %s\n" "$address" "$hostname" "$domain" "$hostname" >> /etc/hosts
	fi
	return

}

lgl_conf_grub()
{
	loccon="$1"
	locser="$2"
	echo "lgl25|Laconian 2.5, Linux|/boot|/|vmlinuz-*|V|ro|Y" > /etc/lc-grub/kernel.conf
	echo "order=\"d:*\"" > /etc/lc-grub/global.conf
	if [ "$loccon" = "ser" ]
	then
		serunit="`echo "$locser" |cut -f1 -d ':'`"
		serspeed="`echo "$locser" |cut -f2 -d ':'`"
		serstop="`echo "$locser" |cut -f3 -d ':'`"
		echo "lgl25|Laconian 2.5, Linux|/boot|/|vmlinuz-*|V|ro console=ttyS${serunit},${serspeed}n8|Y" > /etc/lc-grub/kernel.conf
		echo "serial --unit=$serunit --speed=$serspeed --stop=$serstop" >> /etc/lc-grub/header.txt
		echo "terminal_input serial" >> /etc/lc-grub/header.txt
		echo "terminal_output serial" >> /etc/lc-grub/header.txt
	fi
	lc-grub -i
	echo "LGRUBCFG=Y" >> /etc/sysconfig/kernel.conf
}
 
lgl_user()
{
	user="$1"
	name="$2"
	hash="$3"
	grps="sudo,adm,wheel,audio,video"
	echo "Adding user $user" >&2
	/usr/sbin/useradd -m -s /bin/bash -c "$name" "$user"
	sleep 2
	/usr/bin/getent passwd  "$user"
	rc=$?
	if [ "$rc" != "0" ]
	then
		echo "*** Error adding user $user *** trying fallback" >&2
		printf "#/bin/bash\n/usr/sbin/useradd -m -s /bin/bash -G \"%s\" -c \"%s\" -p \"%s\" %s\n" "$grps" "$name" "$hash" $user > /tmp/useradd.sh
		chmod +x /tmp/useradd.sh
		/tmp/useradd.sh
	else
		echo "Setting admin groups for $user" >&2
		/usr/sbin/usermod -a -G "$grps" "$user"
		sleep 1
		echo "Setting password $user" >&2
		/usr/sbin/usermod -p "$hash" "$user"
	fi
	sleep 5
}

lgl_profile()
{
	charset="$1"
	language="$2"
	echo "export LANG=$language.$charset"
	echo ""
}

lgl_clock()
{
	clock="$1"
	echo "# Set UTC=1 if your system clock stores time in UTC"
	if [ "x$clock" = "localtime" ]
	then
		echo "UTC=0"
	else
		echo "UTC=1"
	fi
	echo "# Set this to any options you might need to give to hwclock,"
	echo "# such as machine hardware clock type for Alphas."
	echo "CLOCKPARAMS="
}

lgl_console()
{
	charset="$1"
	keymap="$2"
	font="$3"
	# We support only utf-8 charset, or latin1-9
	if [ "x$charset" = "xUTF-8" ]
	then
		echo 'UNICODE="1"'
	fi
	if [ "x$keymap" != "x" ]
	then
		echo "KEYMAP=\"$keymap\""
	fi
	if [ "x$font" != "x" ]
	then
		echo "FONT=\"$font\""
	fi
}

PATH=/sbin:/bin:/usr/sbin:/usr/bin:/kronos export PATH


logger -t zeus "moving packages to stagearea"
rm -f /var/lib/lpm/stagearea/*.lpk
mv /idaion-andron/*.lpk /var/lib/lpm/stagearea/.
echo "/var/lib/lpm/stagearea" > /etc/lpc-dirs.conf


logger -t zeus "installing basefiles"
/kronos/lpm -l /tmp/zeusrise.log -f -I lgl-basefiles
logger -t zeus "installing lpm"
/kronos/lpm -l /tmp/zeusrise.log -f -I glibc bash lpm openssl-bin ldif-tools


logger -t zeus "installig kernel"

/usr/bin/lpm -l /tmp/zeusrise.log -f -I mkinitrd

/usr/bin/lpm -l /tmp/zeusrise.log -f -I kernel-img

# We have to make sure lgl-bootscripts are installed before initd-tools
/usr/bin/lpm -l /tmp/zeusrise.log -f -I lgl-bootscripts


logger -t zeus "installing the minimal system"
/usr/bin/lpm -l /tmp/zeusrise.log -f -I lgl-minimal
rc=$?
if [ "$rc" != "0" ]
then
	echo "failure installing the minimal system"
	echo "dropping you to a shell. When you exit, the script will continue"
	/bin/bash 
fi

PATH=/sbin:/bin:/usr/sbin:/usr/bin export PATH
hash -r
logger -t zeus "setting timezone"
if [ -f "/usr/share/zoneinfo/$timezone" ]
then
	ln -sfv "/usr/share/zoneinfo/$timezone" /etc/localtime
fi

rm /bin/sh
cd /bin
ln -s bash sh
printf "Do you want to install grub in /dev/sda [Y/n] ? "
read ans
printf "\n"
if [ "x$ans" != "xn" ]
then
	logger -t zeus "installig grub"
	echo "Ok, installing grub"
	grub-install /dev/sda
	lgl_conf_grub "$lglcon" "$lglser"
fi

>/etc/lpm.conf
printf "dist_name		= LGL\n" >> /etc/lpm.conf
printf "dist_vers		= 2.5\n" >> /etc/lpm.conf
printf "arch_name		= %s\n" "`uname -m`" >> /etc/lpm.conf
printf "lpc_backend		= lpc-dirs.so\n" >> /etc/lpm.conf


logger -t zeus "activating daemons"

/sbin/install_initd atd
/sbin/install_initd ntpd
/sbin/install_initd cron
/sbin/install_initd sshd
/sbin/install_initd rsyslog
/sbin/install_initd sendsignals
/sbin/install_initd iptables
/sbin/install_initd rpcbind
/sbin/install_initd nfs-client





logger -t zeus "registering repositories"

repo_base="http://lpk.laconian-linux.org/lgl-2.5"
conf_base="lgl-2.5.conf"
for repo in default
do
	echo "site_base=$repo_base/$repo/" > /etc/lpc-http-sites/$repo-$conf_base
	echo "auth_type=none" >> /etc/lpc-http-sites/$repo-$conf_base
done	
sed -i 's/lpc-dirs.so/lpc-http.so/g' /etc/lpm.conf	
