#!/bin/bash
LGL=/mnt/lgl
mkdir -pv $LGL/{dev,proc,sys,run}
mount -v --bind /dev $LGL/dev
mount -v --bind /dev/pts $LGL/dev/pts
mount -vt proc proc $LGL/proc
mount -vt sysfs sysfs $LGL/sys
mount -vt tmpfs tmpfs $LGL/run
if [ -h $LGL/dev/shm ]; then
  mkdir -pv $LGL/$(readlink $LGL/dev/shm)
else
  mount -t tmpfs -o nosuid,nodev tmpfs $LGL/dev/shm
fi
mkdir -pv $LGL/{etc,var} $LGL/usr/{bin,lib,sbin}

for i in bin lib sbin; do
  ln -sv usr/$i $LGL/$i
done

mkdir -pv $LGL/lib64 

mkdir -p $LGL/var/log



mknod -m 600 $LGL/dev/console c 5 1
mknod -m 666 $LGL/dev/null c 1 3
mkdir -p $LGL/tmp
chmod 1777 $LGL/tmp
mkdir $LGL/etc
touch $LGL/etc/.first_run
echo "127.0.0.1		localhost" >/etc/hosts
cat > $LGL/etc/nsswitch.conf << "EOF"
# Begin /etc/nsswitch.conf

passwd: files
group: files
shadow: files

hosts: files dns
networks: files

protocols: files
services: files
ethers: files
rpc: files

# End /etc/nsswitch.conf
EOF

cat > $LGL/etc/passwd << "EOF"
root:x:0:0:root:/root:/bin/bash
bin:x:1:1:bin:/dev/null:/usr/bin/false
daemon:x:6:6:Daemon User:/dev/null:/usr/bin/false
messagebus:x:18:18:D-Bus Message Daemon User:/run/dbus:/usr/bin/false
uuidd:x:80:80:UUID Generation Daemon User:/dev/null:/usr/bin/false
nobody:x:65534:65534:Unprivileged User:/dev/null:/usr/bin/false
EOF
cat > $LGL/etc/group << "EOF"
root:x:0:
bin:x:1:daemon
sys:x:2:
kmem:x:3:
tape:x:4:
tty:x:5:
daemon:x:6:
floppy:x:7:
disk:x:8:
lp:x:9:
dialout:x:10:
audio:x:11:
video:x:12:
utmp:x:13:
usb:x:14:
cdrom:x:15:
adm:x:16:
messagebus:x:18:
input:x:24:
sudo:x:27:
mail:x:34:
kvm:x:61:
uuidd:x:80:
wheel:x:97:
users:x:999:
nogroup:x:65534:
EOF
clear
chroot "$LGL" /kronos/busybox env -i \
    HOME=/                  \
    TERM="$TERM"            \
    lglcon="$lglcon"            \
    lgldev="$lgldev"            \
    TERM="$TERM"            \
    PS1='\u:\w\$ '          \
    PATH=/kronos \
    /kronos/busybox ash -l -c /kronos/kronosrule.sh 

