#!/bin/bash


LGL=/mnt/lgl
mkdir -pv $LGL/{dev,proc,sys,run,tmp}
mkdir -p $LGL/var/log
mkdir -p $LGL/bin
mknod -m 600 $LGL/dev/console c 5 1
mknod -m 666 $LGL/dev/null c 1 3
mount -v --bind /dev $LGL/dev
mount -vt devpts devpts $LGL/dev/pts -o gid=5,mode=620
mount -vt proc proc $LGL/proc
mount -vt sysfs sysfs $LGL/sys
mount -vt tmpfs tmpfs $LGL/run
mkdir -p $LGL/tmp
chmod 1777 $LGL/tmp
if [ -h $LGL/dev/shm ]; then
  mkdir -pv $LGL/$(readlink $LGL/dev/shm)
fi
mkdir $LGL/etc
clear
chroot "$LGL" /kronos/busybox env -i \
    HOME=/                  \
    TERM="$TERM"            \
    lglcon="$lglcon"            \
    lgldev="$lgldev"            \
    TERM="$TERM"            \
    PS1='\u:\w\$ '          \
    PATH=/kronos \
    /kronos/busybox ash -l -c /kronos/lglup-krule.sh

