#!/kronos/ash

lgl_xkeyboard()
{
	xlayout="`echo "$1"|cut -f1 -d ':'`"
	xvariant="`echo "$1"|cut -f2 -d ':'`"

	if [ -d "/etc/X11/xorg.conf.d/" ] && [ "x$xlayout" != "x" ]
	then
		printf "Section \"InputClass\"\n" > /etc/X11/xorg.conf.d/00-keyboard.conf
		printf "    Identifier \"system-keyboard\"\n" >> /etc/X11/xorg.conf.d/00-keyboard.conf
		printf "    \n" >> /etc/X11/xorg.conf.d/00-keyboard.conf
		printf "    MatchIsKeyboard \"on\"\n" >> /etc/X11/xorg.conf.d/00-keyboard.conf
		printf "    Option \"XkbLayout\" \"%s\"\n" "$xlayout" >> /etc/X11/xorg.conf.d/00-keyboard.conf
		printf "    Option \"XkbModel\" \"pc104\"\n" >> /etc/X11/xorg.conf.d/00-keyboard.conf
		if [ "x$xvariant" != "x" ]
		then
			printf "    \"XkbVariant\" \",%s\"\n" "$xvariant" >> /etc/X11/xorg.conf.d/00-keyboard.conf
		fi
		printf "EndSection\n" >> /etc/X11/xorg.conf.d/00-keyboard.conf
	fi
	return
}

lgl_network()
{
	gaiaconf="$1"
	hostname="`gaia_val lglHostname`"
	domain="`gaia_val lglDomain`"
	iface="`gaia_val lglNetInterface`"
	if [ "$iface" != "user" ]
	then
		method="`gaia_val lglNetMethod`"
		address="`gaia_val lglNetAddr`"
		prefix="`gaia_val lglNetPrefix`"
		gateway="`gaia_val lglNetGateway`"
		dnssearch="`gaia_val lglNetDnsSearch`"
		dnsserver="`gaia_val lglNetDnsServer`"
	fi
	# First, we let udev handle the fixed device
	/bin/bash /lib/udev/init-net-rules.sh
	# We also set the hostname in any case
	echo "$hostname" > /etc/hostname
	# We also set the localhost stuff in any case
	echo "127.0.0.1 localhost" > /etc/hosts
	# If we have no interface now, we're finished
	if [ "x$iface" = "x" ] || [ "$iface" = "user" ]
	then
		return
	fi
	if [ "$method" = "dhcp" ]
	then
		printf "ONBOOT=\"yes\"\n" > /etc/sysconfig/ifconfig.$iface
		printf "IFACE=\"%s\"\n" "$iface" >> /etc/sysconfig/ifconfig.$iface
		printf "SERVICE=\"dhcpcd\"\n" >> /etc/sysconfig/ifconfig.$iface
		printf "DHCP_START=\"-b -q -4 -h \$HOSTNAME\"\n" >> /etc/sysconfig/ifconfig.$iface
		printf "DHCP_STOP=\"-k  \"\n" >> /etc/sysconfig/ifconfig.$iface
	elif [ "$method" = "static" ]
	then
		printf "ONBOOT=\"yes\"\n" > /etc/sysconfig/ifconfig.$iface
		printf "IFACE=\"%s\"\n" "$iface" >> /etc/sysconfig/ifconfig.$iface
		printf "SERVICE=\"ipv4-static\"\n" >> /etc/sysconfig/ifconfig.$iface
		printf "IP=\"%s\"\n" "$address" >> /etc/sysconfig/ifconfig.$iface
		printf "GATEWAY=\"%s\"\n" "$gateway" >> /etc/sysconfig/ifconfig.$iface
		printf "PREFIX=\"%s\"\n" "$prefix" >> /etc/sysconfig/ifconfig.$iface
		printf "domain %s\n" "$dnssearch" >/etc/resolv.conf
		printf "nameserver %s\n" "$dnsserver" >>/etc/resolv.conf
		printf "%s %s.%s %s\n" "$address" "$hostname" "$domain" "$hostname" >> /etc/hosts
	fi
	/sbin/ifup "$iface"
	return

}

lgl_conf_grub()
{
	loccon="$1"
	locser="$2"
	echo "lgl27|Laconian 2.7, Linux|/boot|/|vmlinuz-*|V|ro|Y" > /etc/lc-grub/kernel.conf
	echo "order=\"d:*\"" > /etc/lc-grub/global.conf
	if [ "$loccon" = "ser" ]
	then
		serunit="`echo "$locser" |cut -f1 -d ':'`"
		serspeed="`echo "$locser" |cut -f2 -d ':'`"
		serstop="`echo "$locser" |cut -f3 -d ':'`"
		echo "lgl27|Laconian 2.7, Linux|/boot|/|vmlinuz-*|V|ro console=ttyS${serunit},${serspeed}n8|Y" > /etc/lc-grub/kernel.conf
		echo "serial --unit=$serunit --speed=$serspeed --stop=$serstop" >> /etc/lc-grub/header.txt
		echo "terminal_input serial" >> /etc/lc-grub/header.txt
		echo "terminal_output serial" >> /etc/lc-grub/header.txt
	fi
	lc-grub -i
	echo "LGRUBCFG=Y" >> /etc/sysconfig/kernel.conf
}
 
lgl_user()
{
	user="$1"
	name="$2"
	hash="$3"
	grps="sudo,adm,wheel,audio,video"
	echo "Adding user $user" >&2
	/usr/sbin/useradd -m -s /bin/bash -c "$name" "$user"
	sleep 2
	/usr/bin/getent passwd  "$user"
	rc=$?
	if [ "$rc" != "0" ]
	then
		echo "*** Error adding user $user *** trying fallback" >&2
		printf "#/bin/bash\n/usr/sbin/useradd -m -s /bin/bash -G \"%s\" -c \"%s\" -p \"%s\" %s\n" "$grps" "$name" "$hash" $user > /tmp/useradd.sh
		chmod +x /tmp/useradd.sh
		/tmp/useradd.sh
	else
		echo "Setting admin groups for $user" >&2
		/usr/sbin/usermod -a -G "$grps" "$user"
		sleep 1
		echo "Setting password $user" >&2
		/usr/sbin/usermod -p "$hash" "$user"
	fi
	sleep 5
}

lgl_profile()
{
	charset="$1"
	language="$2"
	echo "export LANG=$language.$charset"
	echo ""
}

lgl_clock()
{
	clock="$1"
	echo "# Set UTC=1 if your system clock stores time in UTC"
	if [ "x$clock" = "localtime" ]
	then
		echo "UTC=0"
	else
		echo "UTC=1"
	fi
	echo "# Set this to any options you might need to give to hwclock,"
	echo "# such as machine hardware clock type for Alphas."
	echo "CLOCKPARAMS="
}

lgl_console()
{
	charset="$1"
	keymap="$2"
	font="$3"
	# We support only utf-8 charset, or latin1-9
	if [ "x$charset" = "xUTF-8" ]
	then
		echo 'UNICODE="1"'
	fi
	if [ "x$keymap" != "x" ]
	then
		echo "KEYMAP=\"$keymap\""
	fi
	if [ "x$font" != "x" ]
	then
		echo "FONT=\"$font\""
	fi
}

gaia_val()
{
	gaia_key="$1"
	$LDIFGET -f -a "$gaia_key" -i $GAIA_CONF 2>/dev/null
	return
}
gaia_one()
{
	gaia_key="$1"
	gaia_ind="$2"
	$LDIFGET -f -n $gaia_ind -a "$gaia_key" -i $GAIA_CONF 2>/dev/null
	return
}

gaia_cnt()
{
	gaia_key="$1"
	$LDIFGET -f -c -a "$gaia_key" -i $GAIA_CONF 2>/dev/null
	return
}

lgl_lpm_install()
{
	pkgs="$1"
	logger -t zeus "installing package(s) <$pkgs>, lpm is $LPM"
	$LPM $LPM_OPTS -I $pkgs 2>/var/log/lpm_install.err
	rc=$?
	if [ "$rc" != "0" ]
	then
		logger -t zeus "failure installing $pkgs, rc=$?"
		logger -t zeus "`cat /var/log/lpm_install.err`"
		echo "failure installing $pkgs" >&2
		echo "more infos in /var/log/lpm_install.err" >&2
		echo "dropping you to a shell. When you exit, the script will continue"
		/kronos/setsid -c /kronos/env -i  \
			HOME=/                          \
			TERM="$TERM"                \
			PS1='\u@\h:\w\$ '        \
			PATH="$PATH"     \
			/kronos/ash -i
	else
		cat /var/log/lpm_install.err >> /var/log/zeusrule.log
	fi
	\rm -f /var/log/lpm_install.err
	return
}

PATH=/sbin:/bin:/usr/sbin:/usr/bin:/kronos export PATH

cp /kronos/gaia.conf /idaion-andron/gaia.conf

GAIA_CONF="/idaion-andron/gaia.conf"

LDIFGET="/kronos/ldifget" export LDIFGET
LPM="/kronos/lpm"
LPM_OPTS="-v -f "

export GAIA_CONF LPM

boot="`gaia_val lglBoot`"
raid="`gaia_val lglRaid`"
clock="`gaia_val lglClock`"
timezone="`gaia_val lglTimezone`"
charset="`gaia_val lglCharset`"
language="`gaia_val lglLanguage`"
keymap="`gaia_val lglKeymap`"
xkbmap="`gaia_val lglKeymapX11`"
xkbmap="`gaia_val lglKeymapX11`"
consfont="`gaia_val lglConsoleFont`"
user="`gaia_val lglUser`"
name="`gaia_val lglName`"
hash="`gaia_val lglPwdHash`"
roothash="`gaia_val lglRootPwdHash`"
lgldev="`gaia_val lglDevice`"
lglcon="`gaia_val lglConsole`"
lgltype="`gaia_val lglInstallType`"
lglkernel="`gaia_val lglKernel`"

if [ "$lglcon" = "ser" ]
then
	lglser="`gaia_val lglSerialParams`"
else
	lglser=""
fi
echo "clock    : <$clock>"
echo "timezone : <$timezone>"
echo "charset  : <$charset>"
echo "language : <$language>"
echo "keymap   : <$keymap>"
echo "consfont : <$consfont>"
echo "name     : <$name>"
echo "user     : <$user>"
echo "password : <$hash>"
echo "boot     : <$boot>"


logger -t zeus "moving packages to stagearea"
rm -f /var/lib/lpm/stagearea/*.lpk
mv /idaion-andron/*.lpk /var/lib/lpm/stagearea/.
echo "/var/lib/lpm/stagearea" > /etc/lpc-dirx.conf
if [ ! -f /var/lib/lpm/stagearea/lpkindex.ldif ]
then
	logger -t zeus "re-generating index"
	/kronos/lpk-index -G -d /var/lib/lpm/stagearea
fi
	

logger -t zeus "outflanking kronos. PATH: $PATH"
rm -f /etc/passwd /etc/group /etc/profile

lgl_lpm_install "basefiles" 

lgl_lpm_install "glibc bash lpm openssl-bin ldif-tools" 

logger -t zeus "switching lpm to installed version"

echo "lpc_backend		= lpc-dirx.so" >> /etc/lpm.conf

LDIFGET="/usr/bin/ldifget" export LDIFGET
LPM="/usr/bin/lpm" export LPM

logger -t zeus "checking boot method: $boot"

if [ "x$raid" = "xmd" ]
then
	lgl_lpm_install mdadm
	logger -t zeus "creating mdadm.conf for raid"
	/sbin/mdadm --examine --scan >/etc/mdadm.conf
fi

# We'd like to be very sure
if [ -f /etc/sysconfig/kernel.conf ]
then
	cp -a /etc/sysconfig/kernel.conf /etc/sysconfig/kernel.conf.old
	grep -v "^MKINITRD" < /etc/sysconfig/kernel.conf.old > /etc/sysconfig/kernel.conf
	if [ "x$boot" = "xplain" ]
	then
		logger -t zeus "set to booting without initrd"
		echo "MKINITRD=N" >> /etc/sysconfig/kernel.conf
	else
		logger -t zeus "setting boot to using an initrd"
		echo "MKINITRD=Y" >> /etc/sysconfig/kernel.conf
	fi
else
	if [ "x$boot" = "xplain" ]
	then
		logger -t zeus "set to booting without initrd"
		echo "MKINITRD=N" >> /etc/sysconfig/kernel.conf
	else
		logger -t zeus "set to booting with an initrd"
		echo "MKINITRD=Y" >> /etc/sysconfig/kernel.conf
	fi
fi

lgl_lpm_install mkinitrd

lgl_lpm_install kernel-img



# We have to make sure lgl-bootscripts are installed before initd-tools
lgl_lpm_install lgl-bootscripts



logger -t zeus "installing the minimal system"
lgl_lpm_install lgl-minimal

PATH=/sbin:/bin:/usr/sbin:/usr/bin export PATH
hash -r
logger -t zeus "overthrowing kronos. PATH: $PATH"


logger -t zeus "setting clock and console"
lgl_console "$charset" "$keymap" "$consfont" > /etc/sysconfig/console
lgl_clock "$clock" > /etc/sysconfig/clock
echo /usr/bin/localedef -i "$language" -f "$charset" "$language"."$charset"
/usr/bin/localedef -i "$language" -f "$charset" "$language"."$charset"
lgl_profile "$charset" "$language" >> /etc/profile
if [ ! -d /etc/profile.d ]
then
	mkdir -p /etc/profile.d || echo "/etc/profile.d exists, ok"
fi
chmod +x /etc/profile
logger -t zeus "registering user $user"

lgl_user "$user" "$name" "$hash"

if [ "x$roothash" != "x" ]
then
	echo "Setting specified root password"
	usermod -p "$roothash" root
else
	randhash="`openssl rand -base64 15|openssl passwd -1 -stdin`"
	echo "Setting random root password"
	usermod -p "$randhash" root
fi
logger -t zeus "setting timezone"
if [ -f "/usr/share/zoneinfo/$timezone" ]
then
	ln -sfv "/usr/share/zoneinfo/$timezone" /etc/localtime
fi
logger -t zeus "registering partitions"
cat > /etc/fstab << "EOF"
# Begin /etc/fstab
# file system       mount-point     type       options               dump  fsck
EOF

have_root_part=N
have_swap_part=N
num_part="`gaia_cnt lglPart`"
cur_part=1
echo "Number of Partitions: $num_part"
if [ "$num_parts" = "0" ]
then
	echo "No partitions to use defined!!" >&2
else
	while ( [ "$cur_part" -le "$num_part" ] )
	do
		part="`gaia_one lglPart $cur_part`"
		pmnt="`echo "$part"|cut -f1 -d ':'`"
		ptyp="`echo "$part"|cut -f2 -d ':'`"
		pdev="`echo "$part"|cut -f3 -d ':'`"
		lgldev="`gaia_one lglPart $cur_part`"
		if [ "$pmnt" = "/" ]
		then
			have_root_part=Y
			printf "%-16s    %-12s    %-10s %-21s 1     1\n" "$pdev" "$pmnt" "$ptyp" "defaults" >>/etc/fstab
		elif [ "$pmnt" = "swap" ]
		then
			have_swap_part=N
			printf "%-19s %-15s %-10s %-21s 0     0\n" "$pdev" "swap" "swap" "pri=1" >>/etc/fstab
		else
			printf "%-19s %-15s %-10s %-21s 1     1\n" "$pdev" "$pmnt" "$ptyp" "defaults" >>/etc/fstab
		fi
		cur_part="` expr $cur_part + 1 `"
	done
fi
cat >>/etc/fstab << "EOF"

proc                /proc          proc       nosuid,noexec,nodev   0     0
sysfs               /sys           sysfs      nosuid,noexec,nodev   0     0
devpts              /dev/pts       devpts     gid=5,mode=620        0     0
tmpfs               /run           tmpfs      defaults              0     0
devtmpfs            /dev           devtmpfs   mode=0755,nosuid      0     0
tmpfs               /dev/shm       tmpfs      nosuid,nodev          0     0
cgroup2             /sys/fs/cgroup cgroup2    nosuid,noexec,nodev   0     0
                                                                                
EOF

logger -t zeus "setting network"
lgl_network "$gaiaconf"
rm /bin/sh
cd /bin
ln -s bash sh
printf "Do you want to install grub in /dev/sda [Y/n] ? "
read ans
printf "\n"
if [ "x$ans" != "xn" ]
then
	logger -t zeus "installig grub"
	echo "Ok, installing grub"
	grub-install /dev/sda
	lgl_conf_grub "$lglcon" "$lglser"
fi
logger -t zeus "banning kronos to tartarus"
cp -a /kronos /tartarus/
lpm -l /var/log/zeusrule.log -f -D kronos
rm -rf /kronos

>/etc/lpm.conf
printf "dist_name		= LGL\n" >> /etc/lpm.conf
printf "dist_vers		= 2.7\n" >> /etc/lpm.conf
printf "arch_name		= %s\n" "`uname -m`" >> /etc/lpm.conf
printf "lpc_backend		= lpc-dirx.so\n" >> /etc/lpm.conf


logger -t zeus "activating daemons"

/sbin/install_initd atd
/sbin/install_initd ntpd
/sbin/install_initd cron
/sbin/install_initd sshd
/sbin/install_initd rsyslog
/sbin/install_initd sendsignals
/sbin/install_initd iptables
/sbin/install_initd rpcbind
/sbin/install_initd nfs-client
/sbin/install_initd netfs





if [ "$lgltype" = "desktop" ]
then
	PKGSYSTEM_ENABLE_FSYNC=0 export PKGSYSTEM_ENABLE_FSYNC
	lgl_lpm_install lgl-desktop

	cp /etc/inittab /etc/inittab.old
	printf "Do you want to install all firmware  [Y/n] ? "
	read ans
	printf "\n"
	if [ "x$ans" != "xn" ]
	then
		lgl_lpm_install kernel-firmware
	fi
	sed -e 's/3:initdefault/5:initdefault/g' < /etc/inittab.old > /etc/inittab
	lgl_xkeyboard "$xkbmap"
	/sbin/install_initd cups
	/sbin/install_initd dbus
	/sbin/install_initd lxdm
	/sbin/install_initd networkmanager
	/sbin/install_initd alsa
	
fi

logger -t zeus "registering repositories"

repo_base="http://lpk.laconian-linux.org/lgl-2.7"
conf_base="lgl-2.7.conf"
for repo in default firmware
do
	echo "site_base=$repo_base/$repo/" > /etc/lpc-http-sites/$repo-$conf_base
	echo "auth_type=none" >> /etc/lpc-http-sites/$repo-$conf_base
done	
sed -i 's/lpc-dirx.so/lpc-http.so/g' /etc/lpm.conf	
if [ "$lglcon" = "ser" ]
then
	serunit="`echo "$lglser" |cut -f1 -d ':'`"
	serspeed="`echo "$lglser" |cut -f2 -d ':'`"
	serstop="`echo "$lglser" |cut -f3 -d ':'`"
	echo "s0:2345:respawn:/sbin/agetty -L ttyS0 $serspeed vt100"  >> /etc/inittab
	echo "s1:2345:respawn:/sbin/agetty -L ttyS1 $serspeed vt100" >> /etc/inittab
fi
cp /var/log/zeusrule.log /idaion-andron/
logger -t zeus "cleaning up"
# The stagearea now contains all installed packages. Not really necessary
lpm -l /var/log/zeusrule.log -d -Z



logger -t zeus "retreating to olymp"
printf "Ok, installation finished. Restart the system [Y/n] ? "
read ans
printf "\n"
if [ "x$ans" != "xn" ]
then
	echo "Ok, see you in a minute"
	exit
else
	echo "Ok, dropping you to a shell. When you exit, the machine will reboot"
    exec /usr/bin/setsid -c /usr/bin/env -i  \
    HOME=/root                          \
    TERM="$TERM"                \
    PS1='\u@\h:\w\$ '        \
    PATH=/usr/bin:/usr/sbin     \
    /bin/bash -i
fi
